"use strict";

(function () {
    let app = angular.module('workstationResearcher', []);

    app.directive('workstationResearcherFeatures', function () {
        return {
            restrict: 'E',
            scope: {},
            templateUrl: 'templates/workstation/researcher/features.html',
            controller: function ($rootScope, $scope) {
                Helpers.MovePropToIsolatedScope($rootScope, $scope, 'selectedWorkstation');
                let ctrl = this;
                $scope.GetLocalized = Helpers.GetLocalized;

                $scope.$watch('selectedWorkstation.employee.task.completedMinutes', completedMinutes => {
                    ctrl.taskProgress = (completedMinutes == null || completedMinutes == 0)
                        ? 0
                        : $rootScope.getTaskPercentage();
                });

                let loadFeatures = () => {
                    ctrl.features = Features.map(feature => {
                        let result = Helpers.Clone(feature);
                        let researchStatus = $rootScope.settings.researchInventory.find(x => x.featureName == result.name);
                        result.stacks = _.orderBy(Helpers.ConvertRequirementsIntoStacks(result.requirements), x => [x.component.type, x.component.name]);
                        result.requiredResearchPoints = Helpers.CalculateRequiredResearchPoints(result.name);
                        result.currentResearchPoints = researchStatus == null ? 0 : researchStatus.researchPoints;
                        result.completed = result.currentResearchPoints >= result.requiredResearchPoints;
                        result.selected =
                            $rootScope.selectedWorkstation.employee.task != null &&
                            $rootScope.selectedWorkstation.employee.task.state == Enums.TaskStates.Running &&
                            $rootScope.selectedWorkstation.employee.task.featureName == feature.name;

                        return result;
                    });

                    console.log('loadFeatures');
                };
                loadFeatures();

                Helpers.RootScopeWatchAndDestroy($scope, 'settings.researchInventory', () => loadFeatures(), true);

                ctrl.research = feature => {
                    let start = () => {
                        $rootScope.selectedWorkstation.employee.task = {
                            featureName: feature.name,
                            totalMinutes: 240,
                            completedMinutes: 0,
                            state: Enums.TaskStates.Running,
                            autoRepeat: $rootScope.selectedWorkstation.employee.task == null ? false : $rootScope.selectedWorkstation.employee.task.autoRepeat
                        };

                        loadFeatures();
                        $rootScope.$broadcast(GameEvents.EmployeeChange);
                    };

                    let task = $rootScope.selectedWorkstation.employee.task;
                    if(task != null && task.state == Enums.TaskStates.Running) {
                        $rootScope.confirm(Helpers.GetLocalized('are_you_sure'), Helpers.GetLocalized('confirm_switch_research'), () => start());
                    } else {
                        start();
                    }
                };

                ctrl.controlledByManager = GetManagerWorkstationByEmployeeId($rootScope.selectedWorkstation.employee.id) != null;
                ctrl.clickAutoRepeat = () => {
                    if (ctrl.controlledByManager) {
                        $rootScope.selectedWorkstation.employee.task.autoRepeat = !$rootScope.selectedWorkstation.employee.task.autoRepeat
                    } else {
                        $rootScope.showMessage('', Helpers.GetLocalized('auto_repeat_warning'));
                    }
                };
            },
            controllerAs: 'ctrl'
        }
    });

    app.directive('workstationResearcherFrameworks', function () {
        return {
            restrict: 'E',
            scope: {},
            templateUrl: 'templates/workstation/researcher/frameworks.html',
            controller: function ($rootScope, $scope) {
                Helpers.MovePropToIsolatedScope($rootScope, $scope, 'selectedWorkstation');
                let ctrl = this;
                $scope.GetLocalized = Helpers.GetLocalized;

                $scope.$watch('selectedWorkstation.employee.task.completedMinutes', completedMinutes => {
                    ctrl.taskProgress = (completedMinutes == null || completedMinutes == 0)
                        ? 0
                        : $rootScope.getTaskPercentage();
                });

                let loadFrameworks = () => {
                    ctrl.frameworks = Frameworks.filter(x => x.name != FrameworkNames.NoFramework).map(framework => {
                        let result = Helpers.Clone(framework);
                        let researchStatus = $rootScope.settings.researchInventory.find(x => x.frameworkName == result.name);

                        result.requiredResearchPoints = Helpers.CalculateRequiredResearchPoints(null, result.name);
                        result.currentResearchPoints = researchStatus == null ? 0 : researchStatus.researchPoints;
                        result.completed = result.currentResearchPoints >= result.requiredResearchPoints;
                        result.selected =
                            $rootScope.selectedWorkstation.employee.task != null &&
                            $rootScope.selectedWorkstation.employee.task.state == Enums.TaskStates.Running &&
                            $rootScope.selectedWorkstation.employee.task.frameworkName == framework.name;
                        return result;
                    });
                };
                loadFrameworks();

                Helpers.RootScopeWatchAndDestroy($scope, 'settings.researchInventory', () => loadFrameworks(), true);

                ctrl.research = framework => {
                    let start = () => {
                        $rootScope.selectedWorkstation.employee.task = {
                            frameworkName: framework.name,
                            totalMinutes: 240,
                            completedMinutes: 0,
                            state: Enums.TaskStates.Running,
                            autoRepeat: $rootScope.selectedWorkstation.employee.task == null ? false : $rootScope.selectedWorkstation.employee.task.autoRepeat
                        };

                        loadFrameworks();
                        $rootScope.$broadcast(GameEvents.EmployeeChange);
                    };

                    let task =$rootScope.selectedWorkstation.employee.task;
                    if(task != null && task.state == Enums.TaskStates.Running) {
                        $rootScope.confirm(Helpers.GetLocalized('are_you_sure'), Helpers.GetLocalized('confirm_switch_research'), () => start());
                    } else {
                        start();
                    }
                };

                ctrl.controlledByManager = GetManagerWorkstationByEmployeeId($rootScope.selectedWorkstation.employee.id) != null;
                ctrl.clickAutoRepeat = () => {
                    if (ctrl.controlledByManager) {
                        $rootScope.selectedWorkstation.employee.task.autoRepeat = !$rootScope.selectedWorkstation.employee.task.autoRepeat
                    } else {
                        $rootScope.showMessage('', Helpers.GetLocalized('auto_repeat_warning'));
                    }
                };
            },
            controllerAs: 'ctrl'
        }
    });
})();